<?php

session_start();

require 'headers.php';

if (!empty($_FILES['blob']) && !empty($_POST['serie'])) {
	$index = $_POST['index'];
	$parametre = $_POST['parametre'];
	$fichier = $_POST['fichier'];
	$serie = $_POST['serie'];
	$extension = pathinfo($fichier, PATHINFO_EXTENSION);
	if (file_exists('../fichiers/' . $serie) && intval($index) === 1 && $parametre === 'remplacer') {
		$fichiers = glob('../fichiers/' . $serie . '/' . '*.*');
		foreach ($fichiers as $f) {
			unlink($f);
		}
	}
	if (!file_exists('../fichiers/' . $serie)) {
		mkdir('../fichiers/' . $serie, 0775, true);
	}
	$chemin = '../fichiers/' . $serie . '/' . $fichier;
	if (move_uploaded_file($_FILES['blob']['tmp_name'], $chemin)) {
		if (in_array($extension, array('jpg', 'jpeg', 'png', 'gif'))) {
			$cheminvignette = '../fichiers/' . $serie . '/vignette_' . $fichier;
			creer_vignette($chemin, $cheminvignette, 250);
		}
		echo 'fichier_importe';
	} else {
		echo 'erreur';
	}
	exit();
} else {
	header('Location: ../');
	exit();
}

function creer_vignette ($src, $dest, $h) {
    $fparts = pathinfo($src);
    $ext = strtolower($fparts['extension']);
    if ($ext == 'gif') {
        $resource = imagecreatefromgif($src);
	} else if ($ext === 'png') {
        $resource = imagecreatefrompng($src);
	} else if ($ext === 'jpg' || $ext === 'jpeg') {
        $resource = imagecreatefromjpeg($src);
	}
	if ($resource !== false) {
		$width  = imagesx($resource);
		$height = imagesy($resource);
		$w  = floor($width * ($h / $height));
		$img = imagecreatetruecolor($w, $h);
		if ($ext === 'png') {
			imagealphablending($img, false);
			imagesavealpha($img, true);
		}
		imagecopyresampled($img, $resource, 0, 0, 0, 0, $w, $h, $width, $height);
		$fparts = pathinfo($dest);
		$ext = strtolower($fparts['extension']);
		if (!in_array($ext, array('jpg', 'jpeg', 'png', 'gif'))) {
			$ext = 'jpg';
		}
		$dest = $fparts['dirname'] . '/' . $fparts['filename'] . '.' . $ext;
		if ($ext == 'gif') {
			imagegif($img, $dest);
		} else if ($ext === 'png') {
			imagepng($img, $dest, 1);
		} else if ($ext === 'jpg' || $ext === 'jpeg') {
			imagejpeg($img, $dest, 85);
		}
	}
}

?>
